/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.ds;

import com.visigenic.vbroker.ds.DSAMessage;
import com.visigenic.vbroker.ds.DSResource;
import com.visigenic.vbroker.ds.DSString;
import com.visigenic.vbroker.ds.DSUser;
import com.visigenic.vbroker.ds.IStream;
import com.visigenic.vbroker.ds.OStream;
import org.omg.CORBA.MARSHAL;

class DSMessage
implements DSResource {
    static final int REQUEST_MSG = 1;
    static final int REPLY_MSG = 2;
    private static final String[] _messageTypeString = new String[]{null, "REQUEST_MSG", "REPLY_MSG"};
    private DSString _version;
    private int _messageType;
    private int _messageNumber;
    private int _userDataLength;
    private byte[] _userData;

    DSMessage(int n) {
        this._version = DSAMessage.VERSION;
        this._messageType = n;
        this._messageNumber = DSUser.counter();
        this._userDataLength = 4;
        this._userData = DSAMessage.USER_DATA;
    }

    DSMessage() {
    }

    public void read(IStream iStream) {
        this._version = new DSString(iStream);
        if (!this._version.string().equals(DSAMessage.VERSION.string())) {
            throw new MARSHAL("Invalid version: " + this._version);
        }
        this._messageType = iStream.read_int();
        if (this._messageType < 1 || this._messageType > 2) {
            throw new MARSHAL("Invalid type: " + this._messageType);
        }
        this._messageNumber = iStream.read_int();
        this._userDataLength = iStream.read_int();
        this._userData = iStream.read_bytes(this._userDataLength);
    }

    public void write(OStream oStream) {
        this._version.write(oStream);
        oStream.write_int(this._messageType);
        oStream.write_int(this._messageNumber);
        oStream.write_int(this._userDataLength);
        oStream.write_bytes(this._userData);
    }

    public String toString() {
        String string = "DSMessage[version=" + this._version + ", messageType=" + _messageTypeString[this._messageType] + ", messageNumber=" + this._messageNumber + ", userDataLength=" + this._userDataLength + ", userData=";
        int n = 0;
        while (n < this._userDataLength) {
            string = String.valueOf(string) + "[" + this._userData[n] + "]";
            ++n;
        }
        return String.valueOf(string) + "]";
    }

    int messageNumber() {
        return this._messageNumber;
    }
}

